# General structure & Compilation Instructions
There are 5 main .cpp files corresponding to:

fista.cpp: Both the parallel and sequential FISTA based algorithms. Compiler takes a preprocessor DPARALLEL=0/1 to compile either the parallel or non parallel version. Parallel version requires open MPI to be installed. To compile, run 
    $ g++ -std=c++17 -O3 -unroll-loops -DPARALLEL=0 fista.cpp utilities.cpp -o ./binaries/fastfist

greedypp.cpp: This is code from the Flowless paper and implements the Greedy++ algorithm. Some minor changes were made to log some required information for the experiments. To compile, run 
    $ /usr/local/gcc/7.2.0/bin/g++ -std=c++17 -O3 -unroll-loops greedypp.cpp utilities.cpp -o ./binaries/ip


mwu.cpp: Corresponds to the MWU based algorithm implementation. To compile, run:
    $ /usr/local/gcc/7.2.0/bin/g++ -std=c++17 -O3 -unroll-loops   mwu.cpp utilities.cpp -o ./binaries/mwu

frankwolfe.cpp: Corresponds to the Frank-Wolfe based algorithm from the Danisch et al paper. To compile, run:
    $ /usr/local/gcc/7.2.0/bin/g++ -std=c++17 -O3 -unroll-loops  frankwolfe.cpp utilities.cpp -o ./binaries/frankwolfe

# Input format
The input format is expected to be a .txt file, of the format 
n m
u1 v1
u2 v2
...
um vm

where n is the number of vertices in G, m is the number of edges, and 0<= ui,vi <= n-1 for all i. Ensure there are no self loops (the algorithms were not tested with self loops, they might work, but care needed). 

In addition, if the optimum load vector is known (i.e b^\ast is known), then the following format is allowed:
n m
u1 v1
u2 v2
...
um vm
b0
b1
...
bn-1

There bi is the i-th vertex optimum density. The algorithm would output the error with respect to bi given at every iteration. 


# Example run 

After compiling, you can test the algorithm on the "Close cliques" dataset using the following:

$ ./binaries/fastfist 200 < ./datasets_cleaned/close-cliques.txt

If you want to run it using the parallel binary, then run:

$ export OMP_NUM_THREADS=16 && ./binaries/fastfist_parallel 200 < ./datasets_cleaned/close-cliques.txt

The 200 here signifies the number of iterations to run the algorithm. All binaries support the same syntax (for example change fastfist above with mwu and it still works using the MWU algorithm). 
